%Acest tutorial este menit ca sa intelegeti mecanismele de baza ale prologului
%Vor fi 3 exemple pentru a arata acest lucru si predicatul cartesian din laboratorul trecut.
%Ultimul predicat dintre acestea merita studiat ca sa puteti intelege cum merge prolog

%reguli generale:
%prolog  va executa predicatele de sus in jos mereu.
%prolog face backtracking pe predicate.

%In cele ce urmeaza o sa arata grafic cum merg predicatele ca sa intelegeti output-ul codului vostru.

%1
get_elem([X1|L1], X) :- L1 \= [], get_elem(L1, X).
%2
get_elem([X1|L1], X) :- X = X1.

% Exemplu grafic pt get_elem([1,2,3], X)
%  pentru a fi mai clar, voi nota primul predicat cu "1" (get_elem([X1|L1], X) :- L1 \= [], get_elem(L1,X).)
%                                    si al doilea cu "2" (get_elem([X1|L1], X) :- X = X1.)
% Un tab in urmatorul exemplu arata nivelul de impricare
%
%[0]   "1"([1,2,3],X)
%[1]       "1"([2,3],X)
%[2]            "1"([3],X) (aici va da fail L1 \= [])
%[3]            "2"([3],X) X se unifica cu 3 (s-a ajuns la capat si ne intoarcem prin callback)
%[4]       "1"([2,3],X) X = 3 si va returna
%[5]   "1"([1,2,3],X) X = 3 si va returna (in monentul asta avem X = 3 o posibila solutie)
%[6]       "2"([2,3],X) X se unifica cu 2 (S-a ajuns la capat si ne intoarcem prin callback)
%[7]   "1"([1,2,3],X) X = 2 si va returna (in momentul asta avem X = 2 o posibila solutie)
%[8]   "2"([1,2,3],X) X se va unifica cu 1 si va returna (in momentul asta avem X = 1 o posibila solutie)

%dupa ce am optinut orice solutie din cele sus mentionate prolog o sa treaca la urmatorul predicat 
%din lista adica al doilea get_elem, si procedura se repeta. Cand s-a ajuns la F =[E1, E2] scrie o pereche la STDOUT                                                                   
%dupa care se intoarce din recursivitate si ea restul de perechi conform exemplului de mai sus
cartesian([X1|L1], [X2|L2],F) :- get_elem([X1|L1],E1), get_elem([X2|L2],E2), F = [E1, E2].

%-----------------------------------------------------------------------------------------------------------------------------------------------

% Urmatorul cod va filtra lista pentru elemente care sunt egale cu 1

% exemplu
%1
get_elem2([X1|L1], X) :- L1 \= [], get_elem2(L1, X).
%2
get_elem2([X1|L1], X) :- X = 1 ,X = X1.

%[0]   "1"([1,2,3],X)
%[1]       "1"([2,3],X)
%[2]            "1"([3],X) (aici va da fail L1 \= [])
%[3]            "2"([3],X) va da fail pt ca va face X = 1 iar dupa X = 3, din cauza ca prolog are variabile care pot sa fie asignate doar o
% data X = X1 va da fail (nu se poate realiza unificarea unei variabile legate la o valoare cu o valoare diferita de aceasta)
%[4]       "1"([2,3],X) va da fail ca nu s-a satisfacut nici [2] nici [3]
%[5]       "2"([2,3],X) va da fail din acelasi motiv ca mai sus i.e. [3]
%[6]   "1"([1,2,3],X) va da fail ca nu s-a satisfacut nici [4] nici [5]
%[7]   "2"([1,2,3],X) va unifica X = 1 si dupa, X = X1 (X1 fiind 1 unificarea are loc si X = 1 va fi o solutie posibila)

%--------------------------------------------------------------------------------------------------------------------------------------------------

%E de remarcat ca putem avea situatii in care sa avem o valaore ok din cauza ca a reusit sa se satisfaca un predicat total
%dar sa avem dupa in output false din cauza ca ULTIMUL DRUM pe care prolog incearca sa il satisfaca va da fals.

% Observati comportamentul pe care il are predicatul daca il apelam cu [2,1,3]
% i.e. get_elem2([2,1,3],X).
%--------------------------------------------------------------------------------------------------------------------------------------------------

% in continuare vom invata cum functioneaza cut-ul i.e. '!'

%cut-ul opreste resatisfacerea tuturor clauzelor din nivelul curent de imbricare
%prima oara va returna true si se trece de acesta, iar a doua oara va returna fals si va face ce am scris mai sus.

%1
get_elem3([X1|L1], X) :- L1 \= [], get_elem3(L1, X), !.
%2
get_elem3([X1|L1], X) :- X = X1.

%[0]   "1"([1,2,3],X)
%[1]       "1"([2,3],X)
%[2]            "1"([3],X) (aici va da fail L1 \= [])
%[3]            "2"([3],X) X se unifica cu 3
%[4]       "1"([2,3],X) se ajunge la cut care returneaza true
%[5]   "1"([1,2,3],X) se ajunge la cut care returneaza true. In acest moment avem o solutie X = 3.
%[6]       "1"([2,3],X) se incearca resatisfacerea lui cut lucru care da fals si opreste resatisfacerea in continuare
%[7]       "2"([2,3],X) nu se va ajunge niciodata aici din cauza cut-ului
%[8]   "1"([1,2,3],X) se ajunge din nou la cut lucru care va face sa fie acelasi comportament ca la [6]
%[9]   "2"([1,2,3],X) acelasi comportament ca la [7]

% TINETI MEREU MINTE. PROLOG FACE BACKTRACKING. ACESTA E CONCEPTUL PRINCIPAL DIN SPATE.

%--------------------------------------------------------------------------------------------------------------------------------------------------

%uitati cum s-ar scrie cartesian pentru ca toate elemente sa fie puse intr-o singura lista.
%e un exemplu didactic f bun. Va recomand sa il integeti.

%last_level e un exemplu de if asa cum v-am zis laboratorul trecut echivalent cu 
%if(VALIID == 1) THEN
%   cartesian2(L1, L2, TAMPON, 1, F), !.
%else
%   F = TAMPON.
last_level(L1, L2, TAMPON, 1, F) :- cartesian2(L1, L2, TAMPON, 1, F), !.
last_level(L1, L2, TAMPON, 0, TAMPON). % E MEREU TRUE daca se reuseste sa se unifice parametrii predicatului

cartesian2([], _, TAMPON, _, F) :- F = TAMPON, !.
cartesian2(L1, [], TAMPON, _, F) :- F = TAMPON, !.
cartesian2([X1|L1], [X2|L2], TAMPON, VALID, F) :- cartesian2([X1|L1], L2, [[X1,X2]|TAMPON], 0, FAUX),
last_level(L1, [X2|L2], FAUX, VALID, F).

%exemplu de rulare cartesian2:
%cartesian2([1,2],[3,4],[],1,F).

% daca intelegeti exemplul de mai sus parerea mea e ca puteti sa faceti tema. Complexitatea lui este putin mai mare sau aproximativa cu cel mai greu
% predicat de scris din cadrul temei. Cel putin asta e parea mea. :)
