% Copyright (C) 2019 Andrei Olaru
 % 
 % Prolog-tester is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General
 % Public License as published by the Free Software Foundation, either version 3 of the License, or any later version.
 % 
 % Prolog-tester is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 % implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 % License for more details.
 % 
 % You should have received a copy of the GNU Lesser General Public License along with Prolog-tester.
 % If not, see <http://www.gnu.org/licenses/>.

setMinus(From, ToRemove, Result) :-
        findall(E, (member(E, From), \+ member(E, ToRemove)), Result).

inter([], _, []) :- !.
inter([H1|T1], L2, [H1|Res]) :-
    member(H1, L2),
    inter(T1, L2, Res), !.
inter([_|T1], L2, Res) :-
    inter(T1, L2, Res).

search([CurrentState|Other], Solution):-
        final_state(CurrentState),
        !,
        reverse([CurrentState|Other], Solution).
search([CurrentState|Other], Solution):-
        next_state(CurrentState, NextState),
        \+ member(NextState, Other),
        search([NextState,CurrentState|Other], Solution).

solve(Solution):-
    initial_state(State),
    search([State], Solution).


%%
%% Albert and Bernard just become friends with Cheryl, and they want to know when her birthday is.
%% Cheryl gives them a list of 10 possible dates:

%% May		 15 16			19
%% June				17	18
%% July	  14	16
%% August 14 15		17
%% Cheryl then tells Albert and Bernard separately the month and the day of her birthday respectively.
%% Albert: I don't know when Cheryl's birthday is, but I know that Bernard doesn't know too. (s1)
%% Bernard: At first I don't [sic] know when Cheryl's birthday is, but I know now. (s2)
%% Albert: Then I also know when Cheryl's birthday is. (s3)
%% So when is Cheryl's birthday?

possible_birthday('May', 15).
possible_birthday('May', 16).
possible_birthday('May', 19).
possible_birthday('June', 17).
possible_birthday('June', 18).
possible_birthday('July', 14).
possible_birthday('July', 16).
possible_birthday('August', 14).
possible_birthday('August', 15).
possible_birthday('August', 17).

unique_day_in_month(M) :- false.

% Solutions should be:
%  M = 'July',
%  D = 14 ;
%  M = 'July',
%  D = 16 ;
%  M = 'August',
%  D = 14 ;
%  M = 'August',
%  D = 15 ;
%  M = 'August',
%  D = 17.
statement1(M, D) :- false.

% Solutions should be:
%  M = 'July',
%  D = 16 ;
%  M = 'August',
%  D = 15 ;
%  M = 'August',
%  D = 17.
statement2(M, D) :- false.

% Solutions should be:
%  M = 'July',
%  D = 16 ;
statement3(M, D) :- false.

%% Wolf, goat, cabbage problem
%% A state will be represented using:
%%   state(ShoreBoat, ShorePeasant, ShoreWolf, ShoreGoat, ShoreCabbage)

opus(est, vest).
opus(vest, est).

initial_state(state(est, est, est, est, est)).
final_state(state(_, vest, vest, vest, vest)).

%% The peasant is traveling alone
next_state(state(ShoreBoat1, ShoreBoat1, ShoreWolf, ShoreGoat, ShoreCabbage),
           state(ShoreBoat2, ShoreBoat2, ShoreWolf, ShoreGoat, ShoreCabbage)) :- false.

%% The peasant is traveling with the wolf
next_state(state(ShoreBoat1, ShoreBoat1, ShoreBoat1, ShoreGoat, ShoreCabbage),
           state(ShoreBoat2, ShoreBoat2, ShoreBoat2, ShoreGoat, ShoreCabbage)) :- false.

%% The peasant is traveling with the goat
next_state(state(ShoreBoat1, ShoreBoat1, ShoreWolf, ShoreBoat1, ShoreCabbage),
           state(ShoreBoat2, ShoreBoat2, ShoreWolf, ShoreBoat2, ShoreCabbage)) :- false.

%%  The peasant is travelling with the cabbage
next_state(state(ShoreBoat1, ShoreBoat1, ShoreWolf, ShoreGoat, ShoreBoat1),
           state(ShoreBoat2, ShoreBoat2, ShoreWolf, ShoreGoat, ShoreBoat2)) :- false.

%% Cheryl has 2 little brothers
%%  * The product of their ages is 144
%%  * The sum of their ages is a 2 digit number
%%  * The brothers have the same age

check_age_1(AgeC, AgeB1, AgeB2) :- false.
check_age_2(AgeC, AgeB1, AgeB2) :- false.
check_age_3(AgeC, AgeB1, AgeB2) :- false.

find_all_ages(R) :- false.
