module Lab6 where

import Data.Maybe

--------------------------------------------------------------------------------
{-
    Clasa PQueue definește interfața pentru toate structurile de coada de
    priorități pe care le vom implementa mai jos.
-}
class PQueue pq where

    -- Construiește o coadă goală de priorități
    empty :: pq a

    -- Verifică dacă e goală
    isEmpty :: pq a -> Bool

    -- Inserează elem în coada de priorități
    insert :: (Ord a) => a -> pq a -> pq a

    -- Întoarce primul element din coada de priorități
    top :: (Ord a) => pq a -> Maybe a

    -- Șterge primul element din coada de priorități
    delete :: (Ord a) => pq a -> pq a

    -- Construiește o coadă de priorități plecând de la o listă de elemente
    fromList :: (Ord a) => [a] -> pq a
    fromList = foldr insert empty

    -- Lista elementelor din coada de priorități
    toList :: (Ord a) => pq a -> [a]
    toList = toListAux []
        where getTop = fromJust . top
              toListAux acc pq
                | isEmpty pq  = acc
                | otherwise = toListAux (getTop pq : acc) (delete pq)


--------------------------------------------------------------------------------

-- 1. a
-- TODO

-- 1. b
-- TODO

-- 2.
-- TODO
