%EX1:

%Pack consecutive duplicates of list elements into sublists.
%If a list contains repeated elements they should be placed in separate sublists.

%pack([a,a,a,a,b,c,c,a,a,d,e,e,e,e],X).
%X = [[a,a,a,a],[b],[c,c],[a,a],[d],[e,e,e,e]]

daca([X1|L1], [[X1|L]|L2], R) :- R = [[X1,X1|L]|L2], !.
daca([X2|L1], [[X1|L]|L2], R) :- R = [[X2]|[[X1|L]|L2]].

pack([X1|[]], R) :- R = [[X1]], !.
pack([X1|L1], R) :- pack(L1, Raux), daca([X1|L1], Raux, R).

test1([1,1,1,2,2,3,3,4,5,2]) :- pack([1,1,1,2,2,3,3,4,5,2], R), R = [[1, 1, 1], [2, 2], [3, 3], [4], [5], [2]].

%Ex2:

%Run-length encoding of a list.
%Use the result of the last problem to implement the so-called run-length encoding data compression method.
%Consecutive duplicates of elements are encoded as terms [N,E] where N is the number of duplicates of the element E.

%encode([a,a,a,a,b,c,c,a,a,d,e,e,e,e],X).
%X = [[4,a],[1,b],[2,c],[2,a],[1,d][4,e]]

number([], CRT, R) :- R is CRT, !.
number([X1|L1], CRT, R) :- number(L1, CRT + 1, R).

encodeaux([], R) :- R = [], !.
encodeaux([[X1|L2]|L], R) :- encodeaux(L, RAUX),  number([X1|L2], 0, Raux2), R = [[Raux2, X1]|RAUX]. 

encode(L1, R) :- pack(L1, L1aux), encodeaux(L1aux, R).

%EX3

%Modified run-length encoding.
%Modify the result of the last problem in such a way that if an element has no duplicates it is simply copied into the result list.
%Only elements with duplicates are transferred as [N,E] terms.

%Example:
%encode_modified([a,a,a,a,b,c,c,a,a,d,e,e,e,e],X).
%X = [[4,a],b,[2,c],[2,a],d,[4,e]]

dacaencode([1, R], R) :- !.
dacaencode([X1, X2], R) :- R = [X1, X2].

encode_modifiedaux([], R) :- R = [], !.
encode_modifiedaux([X1|L1], R) :- encode_modifiedaux(L1, Raux1), dacaencode(X1, Raux2), R = [Raux2|Raux1].

encode_modified(L1, R) :- encode(L1, Raux), encode_modifiedaux(Raux, R).

%EX4

%Decode a run-length encoded list.
%Given a run-length code list generated as specified in the last problem. Construct its uncompressed version.

concatinvers([], L2, L2) :- !.
concatinvers([X1|L1], L2, R) :- concatinvers(L1, [X1|L2], R).

strech([0, X2], Raux, R) :- R = Raux, !.
strech([X1,X2], Raux ,R) :- X1aux is X1 -1, strech([X1aux, X2], [X2|Raux], R).

dacadecode([X1,X2],Raux, R) :- strech([X1, X2], [], Raux2), concatinvers(Raux2, Raux, R), !.
dacadecode(X1, Raux, R) :- R = [X1|Raux].

decode([], R) :- R = [], !.
decode([X1|L1], R) :- decode(L1, Raux), dacadecode(X1, Raux, R).

%EX5

%Extract a slice from a list.
%Given two indices, I and K, the slice is the list containing the elements between the
%I'th and K'th element of the original list (both limits included). Start counting the elements with 1.

%Example:
%slice([a,b,c,d,e,f,g,h,i,k],3,7,L).
%L = [c,d,e,f,g]

daca_slice([H|T], CRT, START, END, LLAST, L) :- CRT >= START, END >= CRT, L = [H|LLAST], !.
daca_slice([H|T], CRT, START, END, LLAST, L) :- L = LLAST.

slice([],CRT,START,END,L) :- L = [], !. 
slice([H|T],CRT,START,END,L) :- CRT > END, L = [], !. 
slice([H|T],CRT,START,END,L) :- CRTT is CRT + 1, slice(T, CRTT, START, END, LLAST), daca_slice([H|T], CRT, START, END, LLAST, L).