import zipfile
import sys
import os
import shutil

grading = True

filename = sys.argv[1][:-4]

# archive file object
zip_ref = zipfile.ZipFile(sys.argv[1], 'r')
# get the name of the content directory
main_dir = zip_ref.namelist()[0]
# extract the archive
result = zipfile.ZipFile(sys.argv[1], 'r').extractall(".")


if not os.path.exists(main_dir):
    print(main_dir + " directory does not exist. Validation failed!")
    exit(0)

if ( not os.path.exists(main_dir+"/src/main/scala/FSets.scala") or
     not os.path.exists(main_dir+"/src/test/scala/FSetsTests.scala") or
     not os.path.exists(main_dir+"/build.sbt")
     ):
    print(main_dir + " invalid IntellIJ project. Validation failed!")
    exit(0)

print("Validation successful!")

if grading:
    print("Grading "+main_dir)
    # copy test file
    os.system("cp grade.py "+main_dir+"/grade.py")
    os.system("cp FSetsTests.scala "+main_dir+"/src/test/scala/FSetsTests.scala")
    os.system("cd "+main_dir+" && sbt test | python3 grade.py")
