#ifndef GRAPH_H
#define GRAPH_H

#include <stddef.h>

#define CITY_NAME_LENGTH 64
#define IATA_LENGTH (3 + 1)

typedef struct {
	char iata[IATA_LENGTH];
	int id;
} Airport;

typedef struct Route {
	Airport *dst;
	unsigned cost_km;
	unsigned cost_min;
	struct Route *next;
} Route;

typedef struct {
	unsigned n_nodes;
	unsigned n_edges;
	Airport *airports;
	Route **routes;
} Graph;

Graph *allocate_graph(unsigned n_nodes, unsigned n_edges);

Graph *load_graph_from_file(const char *path);

void add_route(Graph *g, unsigned src_id, unsigned dst_id, unsigned cost_km,
	       unsigned cost_min);

void free_graph(Graph *graph);

static unsigned cost_km(Route *r)  { return r->cost_km; }
static unsigned cost_min(Route *r) { return r->cost_min; }
static unsigned cost_hops(Route *r) { (void)r; return 1; }

#endif /* GRAPH_H */
