#include <Wire.h> // Library for I2C communication
#include <LiquidCrystal_I2C.h> // Library for LCD
#include <SoftwareSerial.h>
float pulse = 0;
String API = "XN7HJ38Q6CCJ9BHH";
#define RX 9 // TX of esp8266 in connected with Arduino pin 9
#define TX 10 // RX of esp8266 in connected with Arduino pin 10
SoftwareSerial esp8266(9, 10);

String WIFI_SSID = "ID";// WIFI NAME
String WIFI_PASS = "PASS"; // WIFI PASSWORD
String HOST = "184.106.153.149"; // thingspeak.com
String PORT = "80";
int countTrueCommand;
int countTimeCommand;
boolean found = false;

LiquidCrystal_I2C lcd = LiquidCrystal_I2C(0x27, 16, 2); // Change to (0x27,20,4) for 20x4 LCD.

int pulsePin = A0;
int blinkPin = 7; // led Breadboard
int fadePin = 13; // led Arduino
int fadeRate = 0; // folosit pentru efectul de fade a LED-ului

// used in the interrupt service routine
volatile int BPM; // numarul de batai date de senzor (analog)
volatile int Signal;
volatile int IBI = 600; // intervalul de timp dintre batai, IBI = InterBeat Interval
volatile boolean Pulse = false; // de la user
volatile boolean QS = false; // pentru arduino

// serial Output
static boolean serialVisual = true;
volatile int rate[10];
volatile unsigned long sampleCounter = 0; // used to determine pulse timing
volatile unsigned long lastBeatTime = 0; // find IBI
volatile int P = 512; // peak in pulse wave
volatile int T = 512; // trough in pulse wave
volatile int thresh = 525; // threshold value that helps determine when a pulse or heartbeat is detected
volatile int amp = 100; // amplitude of pulse waveform
volatile boolean firstBeat = true; // folosit pentru a avea valori rezonabile in array ul pulsului
volatile boolean secondBeat =  false; // folosit pentru a avea valori rezonabile in array ul pulsului


void setup() {
  // Initiate the LCD:
  lcd.init();
  lcd.backlight();
  pinMode(blinkPin, OUTPUT); // pin that will blink to your heartbeat!
  pinMode(fadePin, OUTPUT); // pin that will fade to your heartbeat!
  Serial.begin(115200);
  interruptSetup(); // folosit pentru a citi sezorul de puls la fiecare 2ms

  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(" Monitor");
  lcd.setCursor(0, 1);
  lcd.print(" Puls pacient ");
  delay(4000);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Obtinere datelor");

  Serial.begin(9600);
  esp8266.begin(115200);
  sendCommand("AT", 5, "OK"); // check if the module is responding
  sendCommand("AT+CWMODE=1", 5, "OK"); // Sets the Wi-Fi mode, Client mode
  sendCommand("AT+CWJAP=\"" + WIFI_SSID + "\",\"" + WIFI_PASS + "\"", 20, "OK"); // Connects to a specific Wi-Fi network by providing SSID and password
}

void loop() {
  // a heartbeat was found
  if (QS == true) {
    fadeRate = 255; // Makes the LED Fade Effect Happen, Set 'fadeRate' Variable to 255 to fade LED with pulse
    serialOutputWhenBeatHappens(); // A Beat Happened, Output that to serial.
    QS = false;
  }
  ledFadeToBeat(); // Makes the LED Fade Effect Happen
  delay(100); // take a break
}

void sendCommand(String command, int maxTime, char readReplay[]) {
  Serial.print(countTrueCommand);
  Serial.print(". at command => ");
  Serial.print(command);
  Serial.print(" ");
  while (countTimeCommand < (maxTime * 1))
  {
    esp8266.println(command);//at+cipsend
    if (esp8266.find(readReplay)) //ok
    {
      found = true;
      break;
    }
    countTimeCommand++;
  }
  if (found == true)
  {
    Serial.println("OK");
    countTrueCommand++;
    countTimeCommand = 0;
  }
  if (found == false)
  {
    Serial.println("Fail");
    countTrueCommand = 0;
    countTimeCommand = 0;
  }
  found = false;
}

void ledFadeToBeat()
{
  fadeRate -= 15; // set LED fade value
  fadeRate = constrain(fadeRate, 0, 255); // keep LED fade value from going into negative numbers!
  analogWrite(fadePin, fadeRate); // fade LED
}

void interruptSetup()
{
  // Initializes Timer2 to throw an interrupt every 2mS.
  TCCR2A = 0x02; // DISABLE PWM ON DIGITAL PINS 3 AND 11, AND GO INTO CTC MODE
  TCCR2B = 0x06; // DON'T FORCE COMPARE, 256 PRESCALER
  OCR2A = 0X7C; // SET THE TOP OF THE COUNT TO 124 FOR 500Hz SAMPLE RATE
  TIMSK2 = 0x02; // ENABLE INTERRUPT ON MATCH BETWEEN TIMER2 AND OCR2A
  sei(); // MAKE SURE GLOBAL INTERRUPTS ARE ENABLED
}

void serialOutputWhenBeatHappens()
{
  if (serialVisual == true)
  {
    Serial.print("*** Heart-Beat Happened *** ");
    Serial.print("BPM: ");
    Serial.println(BPM);
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("BPM: ");
    lcd.setCursor(0, 1);
    lcd.print(BPM);
    delay(100);
    String getData = "GET /update?api_key=" + API + "&field1=" + BPM;
    sendCommand("AT+CIPMUX=1", 5, "OK");
    sendCommand("AT+CIPSTART=0,\"TCP\",\"" + HOST + "\"," + PORT, 15, "OK");
    sendCommand("AT+CIPSEND=0," + String(getData.length() + 4), 4, ">");
    esp8266.println(getData);
    delay(1500);
    countTrueCommand++;
    sendCommand("AT+CIPCLOSE=0", 5, "OK");
  }
}

ISR(TIMER2_COMPA_vect) //triggered when Timer2 counts to 124
{
  cli(); // disable interrupts while we do this
  Signal = analogRead(pulsePin); // read the Pulse Sensor
  sampleCounter += 2; // keep track of the time in mS with this variable
  int N = sampleCounter - lastBeatTime; // monitor the time since the last beat to avoid noise
  // find the peak and trough of the pulse wave

  if (Signal < thresh && N > (IBI / 5) * 3) // avoid dichrotic noise by waiting 3/5 of last IBI
  {
    if (Signal < T) // T is the trough
    {
      T = Signal; // keep track of lowest point in pulse wave
    }
  }
  if (Signal > thresh && Signal > P)
  { // thresh condition helps avoid noise
    P = Signal; // P is the peak
  } // keep track of highest point in pulse wave
  // NOW IT'S TIME TO LOOK FOR THE HEART BEAT
  // signal surges up in value every time there is a pulse
  if (N > 250)
  { // avoid high frequency noise
    if ( (Signal > thresh) && (Pulse == false) && (N > (IBI / 5) * 3) )
    {
      Pulse = true; // set the Pulse flag when we think there is a pulse
      digitalWrite(blinkPin, HIGH); // turn on pin 13 LED
      IBI = sampleCounter - lastBeatTime; // measure time between beats in mS
      lastBeatTime = sampleCounter; // keep track of time for next pulse

      if (secondBeat)
      { // if this is the second beat, if secondBeat == TRUE
        secondBeat = false; // clear secondBeat flag
        for (int i = 0; i <= 9; i++) // seed the running total to get a realisitic BPM at startup
        {
          rate[i] = IBI;
        }
      }
      if (firstBeat) // if it's the first time we found a beat, if firstBeat == TRUE
      {
        firstBeat = false; // clear firstBeat flag
        secondBeat = true; // set the second beat flag
        sei(); // enable interrupts again
        return; // IBI value is unreliable so discard it
      }
      // keep a running total of the last 10 IBI values
      word runningTotal = 0; // clear the runningTotal variable
      for (int i = 0; i <= 8; i++)
      { // shift data in the rate array
        rate[i] = rate[i + 1]; // and drop the oldest IBI value
        runningTotal += rate[i]; // add up the 9 oldest IBI values
      }
      rate[9] = IBI; // add the latest IBI to the rate array
      runningTotal += rate[9]; // add the latest IBI to runningTotal
      runningTotal /= 10; // average the last 10 IBI values
      BPM = 60000 / runningTotal; // how many beats can fit into a minute? that's BPM!
      QS = true; // set Quantified Self flag
      // QS FLAG IS NOT CLEARED INSIDE THIS ISR
      pulse = BPM;
    }
  }
  if (Signal < thresh && Pulse == true)
  { // when the values are going down, the beat is over
    digitalWrite(blinkPin, LOW); // turn off pin 13 LED
    Pulse = false; // reset the Pulse flag so we can do it again
    amp = P - T; // get amplitude of the pulse wave
    thresh = amp / 2 + T; // set thresh at 50% of the amplitude
    P = thresh; // reset these for next time
    T = thresh;
  }
  if (N > 2500)
  { // if 2.5 seconds go by without a beat
    thresh = 512; // set thresh default
    P = 512; // set P default
    T = 512; // set T default
    lastBeatTime = sampleCounter; // bring the lastBeatTime up to date
    firstBeat = true; // set these to avoid noise
    secondBeat = false; // when we get the heartbeat back
  }
  sei(); // enable interrupts when youre done!
}// end isr
