//Staicu Matei 336CB
#include <LiquidCrystal.h>
//pinii LCD
const int rs = 12;
const int en = 11;
const int d4 = 5;
const int d5 = 4;
const int d6 = 3;
const int d7 = 2;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7);

//pinii analog
const int MQ3 = A0;
const int ageSensor = A1;
const int sexSensor = A2;

//pinii digital
const int BUTTON1 = 6;
const int BUTTON2 = 7;
const int BUZZER = 13;

//constante
const int ageReadingMin = 0;
const int ageReadingMax = 1023;
const int ageMin = 18;
const int ageMax = 99;
const int male = 0;
const int female = 1;
const float legalLimit = 0.2;

//masuratori
int age = 0;
int sex = 0;
float concentration = 0;
int measurementDuration = 5000;
int warmingDuration = 30000;
int startButtonPhase = 0;

void setup() {
  lcd.begin(16, 2);
  Serial.begin(9600);
  pinMode(BUTTON1, INPUT);
  pinMode(BUTTON2, INPUT);
  pinMode(BUZZER, OUTPUT);
  warmup();
  initialState();
}

void loop() {

  if(digitalRead(BUTTON1) == HIGH){
    initialState();
  }
  int startButton = digitalRead(BUTTON2);
  if(startButton == HIGH) startButtonPhase++;
  Serial.println("Start button phase: " + String(startButtonPhase));
  delay(100);
  if(startButtonPhase == 1){
    measureInput();
  }
  if(startButtonPhase == 2){
    float MQ3Value = measureMultipleTimesMQ3();
    concentration = calculateConcentration(age, sex, MQ3Value);
    startButtonPhase++;
  }
  if(startButtonPhase > 2 && startButtonPhase % 2 == 1){
    displayConcentration(concentration);
    if(concentration > legalLimit) tone(BUZZER, 1000, 100);
  }
  if(startButtonPhase > 2 && startButtonPhase % 2 == 0){
    calculateTimeAndRisk(concentration, age, sex);
    if(concentration > legalLimit) tone(BUZZER, 1000, 100);
  }
}
void measureInput(){
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Enter age, sex");
  Serial.println("Entered measureInput");

  //citeste informatiile despre varsta si sex
  age = map(analogRead(ageSensor), ageReadingMin, ageReadingMax, ageMin, ageMax);
  if(analogRead(sexSensor) < 512) sex = male;
  else sex = female;

  lcd.setCursor(0,1);
  if(sex == male) lcd.print("Age:" + String(age) + "Sex:Male");
  else lcd.print("Age:" + String(age) + "Sex:Female");
  Serial.println("Finished measureInput");
}

float measureMultipleTimesMQ3(){
  lcd.clear();
  lcd.setCursor(2,1);
  lcd.print("Measuring...");
  Serial.println("Entered measureMultipleTimesMQ3");
  long startTime = millis();
  long endTime = startTime + measurementDuration;
  long sensorValueSum = 0;
  int readingsCount = 0;

  while(millis() < endTime){
    int sensorValue = analogRead(MQ3);
    sensorValueSum += sensorValue;
    readingsCount++;
    delay(10);
  }
  int averageSensorValue = sensorValueSum / readingsCount;
  Serial.println("Finished measureMultipleTimesMQ3");
  return averageSensorValue;
}

float calculateConcentration(int age, int sex, int sensorValue){
  Serial.println("Entered calculateConcentration");
  const float sensitivity = 0.15;
  const float referenceVoltage = 5.0;
  float weightFactor = 0.05;
  if(age == female) {
    weightFactor = 0.06;  
  }
  float voltage = sensorValue * (referenceVoltage / 1023.0);
  float concentration = voltage * sensitivity;

  if(age < 25) {
    concentration *= 0.9;
  }

  if(sex == male) {
    concentration *= (1- weightFactor);
  } else if(sex == female){
    concentration *= (1 + weightFactor);
  }
  displayConcentration(concentration);
  Serial.println("Finished calculateConcentration");
  return concentration;
}

void calculateTimeAndRisk(float concentration, int age, int sex){
  const float menAir = 0.16;
  const float womenAir = 0.12;
  Serial.println("Entered calculateTimeAndRisk");

  float waitingTime = 0;
  if(sex == male){
    waitingTime = concentration / menAir;
  } else if(sex == female){
    waitingTime = concentration / womenAir;
  }

  float risk = 0;
  float sexFactor = 0;
  float ageFactor = 0;
  if(sex == male){
    sexFactor = 1;
  } else if(sex == female){
    sexFactor = 0.8;
  }
  if(age < 25){
    ageFactor = 1.2;
  } else if(age >= 25 && age <= 65){
    ageFactor = 1;
  } else if(age > 65){
    ageFactor = 1.3;
  }
  risk = concentration * sexFactor * ageFactor * 100;
  int hours = waitingTime;
  int minutes = (waitingTime - hours) * 60;
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Time: " + String(hours) + "h" + String(minutes) + "m");
  lcd.setCursor(0, 1);
  lcd.print("Risk: " + String(risk) + "%");
  Serial.println("Finished calculateTimeAndRisk");
}

void displayConcentration(float concentration){
  Serial.println("Entered displayConcentration");
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(String(concentration) + "mg/L");
  lcd.setCursor(2, 1);
  if(concentration <= legalLimit) lcd.print("Drive safe");
  else lcd.print("Can't drive");
  Serial.println("Finished displayConcentration");
}

void warmup(){
  Serial.println("Entered warmup");
  lcd.clear();
  lcd.setCursor(2,1);
  lcd.print("Warming Up...");
  long startTime = millis();
  long endTime = startTime + warmingDuration;
  while(millis() < endTime){
  }
  Serial.println("Finished warmup");
}

void initialState(){
  Serial.println("Ready");
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Ready to measure");
  lcd.setCursor(5, 1);
  lcd.print("Start");
  startButtonPhase = 0;
}
