package utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import song.*;
import user.User;
import user.UserType;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class JSONReader {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static List<User> readUsers(String filePath) throws IOException {
        List<User> users = new ArrayList<>();
        JsonNode rootNode = objectMapper.readTree(new File(filePath));
        for (JsonNode node : rootNode) {
            UserType type = UserType.valueOf(node.get("type").asText().toUpperCase());
            String firstName = node.get("firstname").asText();
            String lastName = node.get("lastname").asText();
            String email = node.get("email").asText();
            String username = node.get("username").asText();
            Integer discount = node.get("discount").asInt();
            // TODO 2: Use UserFactory.createUser() to create the user
            User user = null;

            // TODO 4: Read "sortingStrategy" from JSON and set appropriate strategy on user
            // Values: "averageScore", "totalViews", "releaseYear"

            users.add(user);
        }

        return users;
    }

    public static List<Song> readSongs(String filePath, List<User> users) throws IOException {
        List<Song> songs = new ArrayList<>();
        JsonNode rootNode = objectMapper.readTree(new File(filePath));
        for (JsonNode node : rootNode) {
            List<String> artists = new ArrayList<>();
            for (JsonNode artistNode : node.get("artists")) {
                artists.add(artistNode.asText());
            }

            List<Rating> ratings = new ArrayList<>();
            for (JsonNode ratingNode : node.get("ratings")) {
                ratings.add(new Rating(
                        ratingNode.get("score").asInt(),
                        ratingNode.get("comment").asText(),
                        LocalDate.parse(ratingNode.get("date").asText()),
                        users
                                .stream()
                                .filter(u -> u.getUsername().equals(ratingNode.get("user").asText()))
                                .findFirst()
                                .orElse(null)
                ));
            }

            String title = node.get("title").asText();
            LocalDate releaseDate = LocalDate.parse(node.get("releaseDate").asText());
            Integer views = node.get("views").asInt();
            Integer duration = node.get("duration").asInt();

            // TODO 3: Use Song.Builder to create the song
            Song song = null;

            songs.add(song);
        }

        return songs;
    }
}
