package user;

import platform.Observer;
import song.Song;
import song.SortingStrategy;

import java.util.List;

/*
 * Subscription values based on user type:
 * - Regular: 9.99
 * - Premium: 14.99
 * - UltraPremium: 19.99
 *
 * For Visitor pattern, the revenue calculation formula per user is:
 * revenue = subscription * (1 - discount / 100.0) * VAT
 * where VAT = 1.19
 */
public abstract class User implements Observer, Element {
    private String firstname;
    private String lastname;
    private String email;
    private String username;
    private Double subscription;
    private Integer discount;
    private SortingStrategy sortingStrategy;

    public User(
            String firstname, String lastname, String email, String username, Double subscription, Integer discount
    ) {
        this.firstname = firstname;
        this.lastname = lastname;
        this.email = email;
        this.username = username;
        this.subscription = subscription;
        this.discount = discount;
    }

    public String getUsername() {
        return username;
    }

    public Double getSubscription() {
        return subscription;
    }

    public Integer getDiscount() {
        return discount;
    }

    public void setSortingStrategy(SortingStrategy sortingStrategy) {
        this.sortingStrategy = sortingStrategy;
    }

    public SortingStrategy getSortingStrategy() {
        return sortingStrategy;
    }

    // TODO 5: Implement Observer interface method
    @Override
    public void update(String message) {
        // Print notification: System.out.println(username + " received: " + message);
    }

    // TODO 6: Implement Element interface method (abstract - implemented in subclasses)
    // Each subclass (Regular, Premium, UltraPremium) must implement:
    // public void accept(Visitor visitor) { visitor.visit(this); }

    public List<Song> getSortedSongs(List<Song> songs) {
        // TODO 4: Return sorted songs using the strategy
        // return sortingStrategy.sortedSongs(songs);
        return null;
    }

    public String toString() {
        return "\n\tUser {" +
                "\n\t\t firstname='" + firstname + '\'' +
                ",\n\t\t lastname='" + lastname + '\'' +
                ",\n\t\t email='" + email + '\'' +
                ",\n\t\t username='" + username + '\'' +
                ",\n\t\t subscription=" + subscription +
                ",\n\t\t discount=" + discount +
                "\n\t}\n";
    }
}
