package song;

import user.User;

import java.time.LocalDate;

public class Rating {
    private Integer score;
    private String comment;
    private LocalDate date;
    private User user;

    public Rating(Integer score, String comment, LocalDate date, User user) {
        this.score = score;
        this.comment = comment;
        this.date = date;
        this.user = user;
    }

    public Integer getScore() {
        return score;
    }

    public User getUser() {
        return user;
    }

    public String toString() {
        return "\n\t\t\t Rating {" +
                "\n\t\t\t\t score=" + score +
                ",\n\t\t\t\t comment='" + comment + '\'' +
                ",\n\t\t\t\t date=" + date.toString() +
                ",\n\t\t\t\t user=" + (user != null ? user.getUsername() : "null") +
                "\n\t\t\t}\n";
    }
}
