package org.poo;

import org.apache.commons.math3.util.FastMath;

public class Main {
    public static void main(String[] args) {
        int principal = 2_000_000_000;   // capital mare
        double rate = 0.05;              // 5% dobândă
        int years = 20;

        int doubledCapital = principal * 2;
        System.out.println("Capital dublat: " + doubledCapital);
        System.out.println("Capital dublat (corect): 4000000000");

        // Venitul total fără dobândă
        double totalRevenueWithoutInterest = principal * years;
        System.out.println("Valoare viitoare a venitului după " + years + " ani: " + totalRevenueWithoutInterest);
        System.out.println("Valoare viitoare a venitului după " + years + " ani (corect): 4.0E10");

        // Venitul total cu dobândă compusă
        double totalRevenueWithInterest = (int)(principal * FastMath.pow(1 + rate, years));
        System.out.println("Valoare viitoare a venitului după " + years + " ani, cu dobândă compusă: " + totalRevenueWithInterest);
        System.out.println("Valoare viitoare a venitului după " + years + " ani, cu dobândă compusă (corect): 5.306595410288844E9");
    }
}
