#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64

#define OLED_RESET -1
#define SCREEN_ADDRESS 0x3C
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// intrari
const int xPin = A2;
const int swPin = 6;
const int pausePin = 7;
const int ldrPin = A0;

// iesiri
const int redPin = 3;
const int yellowPin = 4;
const int greenPin = 5;

// stare joc
bool paused = false;
bool loser = false;
bool winner = false;
bool lightMode = false;
int lives = 3;
int ldrValue = 0;
int threshold = 100;

// caramizi
const int rows = 3;
const int cols = 6;
const int w = SCREEN_WIDTH / cols;
const int h = 5;
bool bricks[rows][cols];
int remaining = rows * cols;

// paleta
int X;
const int W = 30;
const int H = 3;
const int speed = 8;

// minge
const float angle = 45;
const int ballSpeed = 4;
float ballX, ballY;
float ballDX, ballDY;

// timer
volatile bool waitDone = false;

// buton
volatile bool pauseTriggered = false;
volatile bool resetTriggered = false;
volatile bool lastPauseState = 1;
volatile bool lastResetState = 1;
volatile unsigned long lastPauseDebounce = 0;
volatile unsigned long lastResetDebounce = 0;
const unsigned long debounceDelay = 50;

// intrerupere apelata cand timerul 1 ajunge la valoarea OCR1A
ISR(TIMER1_COMPA_vect) {
	// semnalizeaza ca timpul de asteptare s-a terminat
	waitDone = true;
	// opreste timerul
	TCCR1B = 0;
}

// porneste un timer pentru o asteptare de aproximativ 1 secunda
void startWaitTimer() {
	// reseteaza semnalul de asteptare
	waitDone = false;

	// dezactiveaza intreruperile
	cli();

	// reseteaza registrele timerului 1
	TCCR1A = 0;
	TCCR1B = 0;
	// reseteaza contorul timerului
	TCNT1 = 0;
	// seteaza valoarea de comparatie pentru aproximativ 1 secunda
	OCR1A = 15624;
	// seteaza modul CTC
	TCCR1B |= (1 << WGM12);
	// seteaza prescaler la 1024 pentru viteza timerului
	TCCR1B |= (1 << CS12) | (1 << CS10);
	// activeaza intreruperea la comparatie
	TIMSK1 |= (1 << OCIE1A);

	// reactiveaza intreruperile
	sei();
}

// intrerupere pentru schimbarea starii butoanelor pause si reset
ISR(PCINT2_vect) {
	// citeste starea actuala a butonului reset
	bool currentReset = PIND & (1 << PIND6);
	// citeste starea actuala a butonului pause
	bool currentPause = PIND & (1 << PIND7);

	// detecteaza apasarea butonului pause
	if (currentPause == 0 && lastPauseState == 1) {
		pauseTriggered = true;
	}
	// detecteaza apasarea butonului reset
	if (currentReset == 0 && lastResetState == 1) {
		resetTriggered = true;
	}

	// actualizeaza starea anterioara a butoanelor
	lastPauseState = currentPause;
	lastResetState = currentReset;
}

// citeste valoarea analogica de pe un canal specific al ADC-ului
uint16_t analogReadReg(uint8_t channel) {
	// configureaza referinta si canalul pentru ADC
	ADMUX = (1 << REFS0) | (channel & 0x07);
	// activeaza ADC-ul si seteaza prescaler la 128
	ADCSRA = (1 << ADEN) | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0);
	// porneste conversia analog-digitale
	ADCSRA |= (1 << ADSC);

	// asteapta pana se termina conversia
	while (ADCSRA & (1 << ADSC));

	// citeste valoarea din registrele ADC
	uint16_t result = ADCL;
	result |= (ADCH << 8);

	return result;
}

void reset() {

	// reinitializare stare joc
	loser = false;
	winner = false;
	remaining = rows * cols;
	lives = 3;

	// setez mod afisare
	display.setTextSize(5);
	display.setTextColor(WHITE);
	
	// afisez 3, 2, 1 pentru a avea timp de pregatire
	display.setCursor(50, 25);
	display.clearDisplay();
	display.println("3");
	display.display();
	startWaitTimer();
	while (!waitDone);
	display.clearDisplay();

	display.setCursor(50, 25);
	display.println("2");
	display.display();
	startWaitTimer();
	while (!waitDone);
	display.clearDisplay();

	display.setCursor(50, 25);
	display.println("1");
	display.display();
	startWaitTimer();
	while (!waitDone);
	display.clearDisplay();

	// aprind toate ledurile
	PORTD |= (1 << PORTD3) | (1 << PORTD4) | (1 << PORTD5);
	X = SCREEN_WIDTH / 2 - W / 2;
	ballX = X + W / 2;
	ballY = SCREEN_HEIGHT - H;

	// directie initiala minge
	ballDX = ballSpeed * cos(radians(angle));
	ballDY = -ballSpeed * sin(radians(angle));

	// exista toate caramizile
	for (int i = 0; i < rows; i++) {
		for (int j = 0; j < cols; j++) {
		bricks[i][j] = true;
		}
	}
}

// afisez elementele pe ecran in functie de luminozitate
void drawGame() {
	display.clearDisplay();
	// fundal
	if (!lightMode) display.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, WHITE);
	// minge
	display.fillCircle(ballX, ballY, 2, lightMode ? WHITE : BLACK);
	// paleta
	display.fillRect(X, SCREEN_HEIGHT - H, W, H, lightMode ? WHITE : BLACK);

	// caramizile
	for (int i = 0; i < rows; i++) {
		for (int j = 0; j < cols; j++) {
		if (bricks[i][j]) {
			display.fillRect(j * w, i * h, w - 1, h - 1, lightMode ? WHITE : BLACK);
		}
		}
	}

	display.display();
}

// afisaj final
void final() {
	display.clearDisplay();
	if (!lightMode) display.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, WHITE);
	display.setTextSize(2);
	display.setTextColor(lightMode ? WHITE : BLACK);
	display.setCursor(20, 30);
	// in functie de rezultatul final
	if (winner) {
		display.println("Winner :)");
	} else {
		display.println("Loser :(");
	}
	display.display();

	// astept pana se da reset
	while (!resetTriggered);
}

void setup() {

	// intreruperile pentru butoane
	PCICR |= (1 << PCIE2);
	PCMSK2 |= (1 << PCINT22);
	PCMSK2 |= (1 << PCINT23);

	display.clearDisplay();

	// intrare pentru butoane
	DDRD &= ~(1 << DDD6);
	DDRD &= ~(1 << DDD7);
	// rezistente pull-up pentru butoane
	PORTD |= (1 << PORTD6);
	PORTD |= (1 << PORTD7); 
	
	// iesiri pentru leduri
	DDRD |= (1 << DDD3);
	DDRD |= (1 << DDD4);
	DDRD |= (1 << DDD5);

	// toate stinse la inceput
	PORTD &= ~((1 << PORTD3) | (1 << PORTD4) | (1 << PORTD5));

	Serial.begin(9600);
	randomSeed(analogReadReg(3));

	if (!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
		Serial.println(F("SSD1306 allocation failed"));
		for (;;);
	}

	// pauza de initializare ecran
	startWaitTimer();
	while (!waitDone);

	// setez modul de luminozitate
	ldrValue = analogReadReg(0);  
	if (ldrValue > threshold) {
		lightMode = false;
	} else {
		lightMode = true;
	}

	reset();
}

// ledurile se sting in functie de numarul de vieti
void updateLeds() {
	PORTD = (PORTD & ~(1 << PORTD3 | 1 << PORTD4 | 1 << PORTD5)) | 
			(lives >= 1 ? (1 << PORTD3) : 0) |
			(lives >= 2 ? (1 << PORTD4) : 0) |
			(lives >= 3 ? (1 << PORTD5) : 0);
}

void resetBall() {
	delay(300);

	// pozitia mingii porneste din centrul paletei
	ballX = X + W / 2;
	ballY = SCREEN_HEIGHT - H;

	ballDX = ballSpeed * cos(radians(angle));
	ballDY = -ballSpeed * sin(radians(angle));
}

void loop() {

	// jocul s-a terminat
	if (loser || winner) {
		final();
	}

	// setez modul de lumina in functie de luminozitate
	ldrValue = analogReadReg(0);  
	if (ldrValue > threshold) lightMode = false;
	else lightMode = true;

	display.setTextColor(lightMode ? WHITE : BLACK);

	// s-a pus pauza
	if (pauseTriggered) {
		pauseTriggered = false;
		paused = !paused;
	}

	// s-a dat reset
	if (resetTriggered) {
		resetTriggered = false;
		reset();
	}

	// joc pus pe pauza
	if (paused) {
		display.clearDisplay();
		if (!lightMode) display.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, WHITE);
		display.setTextSize(2);
		display.setTextColor(lightMode ? WHITE : BLACK);
		display.setCursor(25, 25);
		display.println("PAUSED");
		display.display();
		return;
	}

	// miscare paleta
	int xValue = analogReadReg(2);

	if (xValue < 400) X -= speed;
	if (xValue > 600) X += speed;

	// sa nu iasa din ecran
	X = constrain(X, 0, SCREEN_WIDTH - W);

	// se continua miscarea
	int prevX = ballX;
	int prevY = ballY;
	ballX += ballDX;
	ballY += ballDY;

	// coliziune margini ecran
	if (ballX <= 0 || ballX >= SCREEN_WIDTH - 2) ballDX = -ballDX;
	if (ballY <= 0) ballDY = -ballDY;

	// coliziune paleta
	if (ballY >= SCREEN_HEIGHT - H && ballX >= X && ballX <= X + W) ballDY = -ballDY;

	for (int i = 0; i < rows; i++) {
		for (int j = 0; j < cols; j++) {
		if (bricks[i][j]) {
			int x = j * w;
			int y = i * h;

			bool hitX = (ballX - 2 >= x && ballX - 2 <= x + w);
			bool hitY = (ballY - 2 >= y && ballY - 2 <= y + h);

			// daca e lovita o caramida o sterg si schimb directia mingii
			if (hitX && hitY) {
			if (prevX < x || prevX > x + w) ballDX = -ballDX;
			if (prevY < y || prevY > y + h) ballDY = -ballDY;
			bricks[i][j] = false;
			remaining--;
			break;
			}
		}
		}
	}

	// nu mai sunt caramizi
	if (remaining == 0) winner = true;

	// mingea a ajuns pe sol
	if (ballY > SCREEN_HEIGHT) {
		lives--;
		updateLeds();
		if (lives > 0) resetBall();
		else loser = true;
	}

	drawGame();
}