#ifndef MPU6050_H
#define MPU6050_H

#include <Arduino.h>
#include "i2c_interface.h"
#include "config.h"

extern int16_t baseAccelX, baseAccelY, baseAccelZ;
extern int16_t baseGyroX, baseGyroY, baseGyroZ;
extern bool isCalibrated;

// MPU6050 functions
bool mpu6050_init(void);
void mpu6050_read_accel(int16_t *accelX, int16_t *accelY, int16_t *accelZ);
void mpu6050_read_gyro(int16_t *gyroX, int16_t *gyroY, int16_t *gyroZ);
void calibrate_sensors(void);

#endif // MPU6050_H