#ifndef I2C_INTERFACE_H
#define I2C_INTERFACE_H

#include <Arduino.h>
#include "config.h"

// I2C functions
void i2c_init(void);
void i2c_start(void);
void i2c_stop(void);
bool i2c_write(uint8_t data);
void i2c_read_ack(uint8_t *data);
void i2c_read_nack(uint8_t *data);
bool write_register(uint8_t device_addr, uint8_t register_addr, uint8_t value);
uint8_t read_register(uint8_t device_addr, uint8_t register_addr);
void read_registers(uint8_t device_addr, uint8_t start_register, uint8_t *buffer, uint8_t length);
void scan_i2c_devices(void);

#endif // I2C_INTERFACE_H