#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <Arduino.h>
#include "config.h"
#include "mpu6050.h"
#include "ble_manager.h"

extern ControlMode currentMode;
extern volatile bool buttonInterruptOccurred;
extern volatile unsigned long lastButtonInterruptTime;

// Controller functions
void process_motion_data(void);
void handle_button_interrupt(void);
void send_mouse_command(int16_t x, int16_t y);
void send_keyboard_command(char key, bool pressed);
void switch_mode(void);
void send_center_cursor_command();

#endif // CONTROLLER_H