#ifndef CONFIG_H
#define CONFIG_H

#include <Arduino.h>

// Pin definitions
#define MODE_BUTTON_PIN         33
#define SDA_PIN                 21
#define SCL_PIN                 22
#define CALIBRATE_BUTTON_PIN    25
#define I2C_FREQ                400000
#define LED_BUILTIN             2

// MPU6050 definitions
#define MPU6050_ADDR            0x68
#define MPU6050_WHO_AM_I        0x75
#define MPU6050_PWR_MGMT_1      0x6B
#define MPU6050_SMPLRT_DIV      0x19
#define MPU6050_CONFIG          0x1A
#define MPU6050_GYRO_CONFIG     0x1B
#define MPU6050_ACCEL_CONFIG    0x1C
#define MPU6050_ACCEL_XOUT_H    0x3B
#define MPU6050_TEMP_OUT_H      0x41
#define MPU6050_GYRO_XOUT_H     0x43
#define MPU6050_PWR_MGMT_2      0x6C

// Constants
#define SERIAL_BAUD_RATE        115200    // Baud rate for serial communication
#define SAMPLE_RATE_MS          20        // Sample rate in milliseconds
#define DEBOUNCE_TIME_MS        50        // Button debounce time in milliseconds
#define ACCEL_THRESHOLD         1000      // Threshold for detecting acceleration
#define GYRO_THRESHOLD          1500      // Threshold for detecting rotation
#define GYRO_DEADZONE           100       // Deadzone for gyro to prevent drift
#define GYRO_SCALE_MAX          6000      // Maximum expected gyro value
#define MOUSE_SPEED_MAX         10        // Maximum mouse speed
#define ACCEL_THRESHOLD_RELEASE 800       // Threshold for releasing keys
#define BT_DEVICE_NAME          "GloveController"

// UUID-uri pentru servicii și caracteristici BLE
#define SERVICE_UUID           "6E400001-B5A3-F393-E0A9-E50E24DCCA9E" // UART service
#define CHARACTERISTIC_UUID_TX "6E400003-B5A3-F393-E0A9-E50E24DCCA9E" // Transmition 
#define CHARACTERISTIC_UUID_RX "6E400002-B5A3-F393-E0A9-E50E24DCCA9E" // Reception

// Operating modes
enum ControlMode {
  MOUSE_MODE,
  KEYBOARD_MODE
};

// Command codes for Bluetooth communication
enum CommandCode {
  MOUSE_MOVE = 1,         // Mișcare mouse
  KEY_PRESS = 2,          // Apasă o tastă
  KEY_RELEASE = 3,        // Eliberează o tastă
  CENTER_CURSOR = 4,      // Trimite comanda pentru centrarea cursorului
  CHANGE_MODE = 5,        // Schimbă modul Mouse/Keyboard
  SET_SENSITIVITY = 6,    // Setează sensibilitatea
  CALIBRATE = 7,          // Declanșează calibrare
  GET_STATUS = 8          // Solicită starea curentă
};

// Extern variables to be shared
extern float mouseAcceleration;   // Acceleration factor for mouse movement
extern float keyboardSensitivity; // Sensitivity factor for keyboard input
#endif // CONFIG_H