`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 10/26/2025 04:58:42 PM
// Design Name: 
// Module Name: full_adder
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////
module half_adder(
        input wire a,
        input wire b,
        output wire s,
        output wire c_out
    );
    //V1 - implementation using structural description with primitives
    xor x1 (s,a,b);
    and a1 (c_out,a,b);
    
    //V2 - implementation using continuous assignment 
    //  V2.1. - still using structural description
    //assign s = a ^ b;
    //assign c_out = a & b;
    //  V2.2  - using behavioral description
    //assign {c_out,s} = a + b; // '{ }' - concatenate operator, cosnidering the result shall handle 2 bits
    
    //V3 - implementation using behavioral description with procedural blocks
    //always@(*) begin
    //  {c_out,s} = a + b;  //c_out and s shall be modified to reg type for this implementation
    //end
endmodule

module full_adder(
        input a,
        input b,
        input c_in,
        output s,
        output c_out
    );
    
    //V1. Implementation using structural description with continuous assignment 
    // assign s = a ^ b ^ c_in;
    // assign c_out = ((a ^ b) & c_in) | (a & b);
    
    //V2. Implementation using structural description with half adder modules
    half_adder H1 (.c_out(c1), .s(s1), .a(a), .b(b));
    half_adder H2 (.c_out(c2), .s(s), .a(s1), .b(c_in));
    or o1 (c_out, c1, c2);
    //V3 - implementation using behavioral description with procedural blocks
    //always@(*) begin
    //  {c_out,s} = a + b + c_in;  //c_out and s shall be modified to reg type for this implementation
    //end
endmodule
